#define GmnBodyLinkObject
// GMNewton 1.00
//
//Function:  Links a GM object and a Newton body together
//Notes:  This makes it possible to do two things:
//          1) Generate correct collision responses in Game Maker
//          2) Allow GMNewton to automatically update transformation of object
//        Setting the body to auto-update is optional
//
//Arguments:
//   Argument0 - dBody
//   Argument1 - objid
//   Argument2 - autoupdate
//call GmnBodyLinkObject(dBody,objid,autoupdate);
//return: 
return external_call(global.__GmnBodyLinkObject__,argument0,argument1,argument2);

#define GmnBodyUnlinkObject
// GMNewton 1.00
//
//Function:  Unlinks a GM object and the Newton body it is linked to
//Notes:  Until re-enabled, the object will not be automatically updated
//        and objects will not be identified in collisions for event generation
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyUnlinkObject(dBody);
//return: 
return external_call(global.__GmnBodyUnlinkObject__,argument0);

#define GmnBodyGetLinked
// GMNewton 1.00
//
//Function:  Check if a body is linked to an object
//Notes:
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyGetLinked(dBody);
//return: 
return external_call(global.__GmnBodyGetLinked__,argument0);

#define GmnBodyGetLinkedObject
// GMNewton 1.00
//
//Function:  Retrieves the id of the object a body is linked to
//Notes:
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyGetLinkedObject(dBody);
//return: 
return external_call(global.__GmnBodyGetLinkedObject__,argument0);

#define GmnBodyAutoGetPosRot
// GMNewton 1.00
//
//Function:  Calls the auto-update script with new position and orientation of given body
//Notes:  Body must be linked to an object
//
//Arguments:
//   Argument0 - dBody
//call GmnBodyAutoGetPosRot(dBody);
//return: 
return external_call(global.__GmnBodyAutoGetPosRot__,argument0);

